VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Begin VB.Form Form2 
   Caption         =   "VB TreeView events"
   ClientHeight    =   3225
   ClientLeft      =   3435
   ClientTop       =   4125
   ClientWidth     =   5100
   ClipControls    =   0   'False
   LinkTopic       =   "Form2"
   MDIChild        =   -1  'True
   ScaleHeight     =   3225
   ScaleWidth      =   5100
   Begin ComctlLib.TreeView TreeView1 
      Height          =   2235
      Left            =   180
      TabIndex        =   2
      Top             =   300
      Width           =   1755
      _ExtentX        =   3096
      _ExtentY        =   3942
      _Version        =   327682
      Style           =   7
      Appearance      =   1
   End
   Begin VB.Frame Frame1 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BorderStyle     =   0  'None
      Caption         =   "Frame1"
      ClipControls    =   0   'False
      ForeColor       =   &H80000008&
      Height          =   2325
      Left            =   2220
      TabIndex        =   1
      Top             =   270
      Width           =   255
   End
   Begin VB.TextBox Text1 
      Height          =   2325
      Left            =   2700
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   0
      Top             =   240
      Width           =   1935
   End
   Begin ComctlLib.ImageList ImageList1 
      Left            =   1440
      Top             =   2640
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      MaskColor       =   12632256
      _Version        =   327682
   End
   Begin VB.Menu mnuOpts 
      Caption         =   "&Options"
      Begin VB.Menu mnuOptsClear 
         Caption         =   "&Clear Output"
         Shortcut        =   ^X
      End
      Begin VB.Menu mnuOptsMouseMove 
         Caption         =   "&MouseMove Event"
         Shortcut        =   ^M
      End
   End
   Begin VB.Menu mnuWindow 
      Caption         =   "&Window"
      WindowList      =   -1  'True
      Begin VB.Menu mnuWindowForm1 
         Caption         =   "&FolderTreeview"
         Shortcut        =   ^{F1}
      End
      Begin VB.Menu mnuWindowForm2 
         Caption         =   "&VB TreeView"
         Enabled         =   0   'False
         Shortcut        =   ^{F2}
      End
      Begin VB.Menu mnuWindowSep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuWindowCascade 
         Caption         =   "&Cascade"
      End
      Begin VB.Menu mnuWindowTileHorizontal 
         Caption         =   "Tile &Horizontal"
      End
      Begin VB.Menu mnuWindowTileVertical 
         Caption         =   "Tile &Vertical"
      End
      Begin VB.Menu mnuWindowArrangeIcons 
         Caption         =   "&Arrange Icons"
      End
   End
End
Attribute VB_Name = "Form2"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' Brought to you by Brad Martinez
'   http://www.mvps.org/ccrp/
'   news://news.mvps.org/ccrp.foldertreeview

' =========================================================
' Demonstrates the behavior and effect of most of the Events in the VB
' TreeView control, for comparison with the FolderTreeview control's events.
'
' - Code was developed using (and is formatted for) 8pt. MS Sans Serif font
' =========================================================

Private m_hwndTB As Long
Private VSplitter As New CVSplitterWnd
'

Private Sub Form_Load()
  Dim Node1 As Node
  Dim Node2 As Node
  Dim Node3 As Node
  Dim i As Integer
  Dim j As Integer
  Dim k As Integer
  
  Set Icon = Nothing
  
  m_hwndTB = Text1.hWnd
'  Text1.MultiLine = True
'  Text1.ScrollBars = vbBoth
  Text1 = ""
  
  With ImageList1
    .ImageWidth = 16
    .ImageHeight = 16
    .ListImages.Add Picture:=LoadPicture("icons\url16.ico")
    .ListImages.Add Picture:=LoadPicture("icons\html16.ico")
    .ListImages.Add Picture:=LoadPicture("icons\regbin16.ico")
  End With
    
  With TreeView1
    ' For some convenience...
    .HideSelection = False
    .ImageList = ImageList1
    .Indentation = 19 * Screen.TwipsPerPixelX   ' default treeview indent
    .LabelEdit = tvwManual
    .LineStyle = tvwRootLines
  
    ' number of Nodes at each respective hierarchical level
    Const nNodes1 = 3
    Const nNodes2 = 4
    Const nNodes3 = 4
    
    ' Fill up the treeview...
    For i = 1 To nNodes1
      Set Node1 = .Nodes.Add(, , , "Root" & i, 1)
      
      For j = 1 To nNodes2
        Set Node2 = .Nodes.Add(Node1.Index, tvwChild, , "Root" & i & "Child" & j, 2)
        
        For k = 1 To nNodes3
          Set Node3 = .Nodes.Add(Node2.Index, tvwChild, , _
                                "GrandChild" & (nNodes2 * nNodes3 * (i - 1)) + (nNodes3 * (j - 1)) + k, 3)
        Next
      Next
  
      Node1.Expanded = True
    Next
      
    .Nodes(1).Selected = True
  End With
  
  ' ===============================================
  ' And the splitter, required property settings:
  
  ScaleMode = vbPixels
  KeyPreview = True
  
'  Frame1.Appearance = 0   ' flat
'  Frame1.BorderStyle = vbBSNone   ' hides the caption
'  Frame1.ClipControls = False
  
  With VSplitter
    Call .SetControls(hWnd, TreeView1.hWnd, Text1.hWnd, Frame1)
    .Left = (ScaleWidth - .Width) * 0.5
    .TrackSplit = True
  End With

End Sub

' ===============================================================
' Menus

Private Sub mnuOptsClear_Click()   ' Crtl+C
  Text1 = ""
End Sub

Private Sub mnuOptsMouseMove_Click()   ' Ctrl+M
  mnuOptsMouseMove.Checked = Not mnuOptsMouseMove.Checked
End Sub

Private Sub mnuWindow_Click()
  mnuWindowForm1.Enabled = (IsFormLoaded("Form1") = False)
End Sub

Private Sub mnuWindowForm1_Click()   ' Crtl+F1
  Form1.Show
End Sub

Private Sub mnuWindowArrangeIcons_Click()
  MDIForm1.Arrange vbArrangeIcons
End Sub

Private Sub mnuWindowTileVertical_Click()
  MDIForm1.Arrange vbTileVertical
End Sub

Private Sub mnuWindowTileHorizontal_Click()
  MDIForm1.Arrange vbTileHorizontal
End Sub

Private Sub mnuWindowCascade_Click()
  MDIForm1.Arrange vbCascade
End Sub

' ===============================================================
 ' TreeView events:

Private Sub TreeView1_Click()
  AppendText m_hwndTB, "Click"
End Sub

Private Sub TreeView1_Collapse(ByVal Node As Node)
  AppendText m_hwndTB, "Collapse: " & Node
End Sub

Private Sub TreeView1_DblClick()
  AppendText m_hwndTB, "DblClick"
End Sub

Private Sub TreeView1_DragDrop(Source As Control, x As Single, y As Single)
  AppendText m_hwndTB, "DragDrop: " & Source.Name & ", " & x & ", " & y
End Sub

Private Sub TreeView1_DragOver(Source As Control, x As Single, y As Single, State As Integer)
  AppendText m_hwndTB, "DragOver: " & Source.Name & ", " & x & ", " & y & ", " & State
End Sub

Private Sub TreeView1_Expand(ByVal Node As Node)
  AppendText m_hwndTB, "Expand: " & Node
End Sub

Private Sub TreeView1_GotFocus()
  AppendText m_hwndTB, "GotFocus"
End Sub

Private Sub TreeView1_KeyDown(KeyCode As Integer, Shift As Integer)
  AppendText m_hwndTB, "KeyDown: " & KeyCode & ", " & Shift
End Sub

Private Sub TreeView1_KeyPress(KeyAscii As Integer)
  AppendText m_hwndTB, "KeyPress: " & KeyAscii
End Sub

Private Sub TreeView1_KeyUp(KeyCode As Integer, Shift As Integer)
  AppendText m_hwndTB, "KeyUp: " & KeyCode & ", " & Shift
End Sub

Private Sub TreeView1_LostFocus()
  AppendText m_hwndTB, "LostFocus"
End Sub

Private Sub TreeView1_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
  AppendText m_hwndTB, "MouseDown: " & Button & " " & Shift & " " & x & " " & y
End Sub

Private Sub TreeView1_MouseMove(Button As Integer, Shift As Integer, x As Single, y As Single)
  If mnuOptsMouseMove.Checked Then
    AppendText m_hwndTB, "MouseMove: " & Button & " " & Shift & " " & x & " " & y
  End If
End Sub

Private Sub TreeView1_MouseUp(Button As Integer, Shift As Integer, x As Single, y As Single)
  AppendText m_hwndTB, "MouseUp: " & Button & " " & Shift & " " & x & " " & y
'TreeView1.SelectedItem.Selected = False
End Sub

Private Sub TreeView1_NodeClick(ByVal Node As Node)
  AppendText m_hwndTB, "NodeClick: " & Node
End Sub

' ===============================================================
' Splitter

Private Sub Form_Resize()
  ' No resize when minimized... does funny things...
  If WindowState <> vbMinimized Then Call VSplitter.AdjustSplitterPosition(True)
End Sub

Private Sub Frame1_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
  If Button = vbLeftButton Then Call VSplitter.BeginSplit(x, y)
End Sub

Private Sub Frame1_MouseMove(Button As Integer, Shift As Integer, x As Single, y As Single)
  If VSplitter.Splitting Then Call VSplitter.MoveSplitter(x, y)
End Sub

Private Sub Frame1_MouseUp(Button As Integer, Shift As Integer, x As Single, y As Single)
  If VSplitter.Splitting Then Call VSplitter.EndSplit(x, y, True)
End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
  If (KeyCode = vbKeyEscape) And VSplitter.Splitting Then Call VSplitter.CancelSplit
End Sub
